VERSION 5.00
Begin VB.Form frmThreadCall 
   AutoRedraw      =   -1  'True
   Caption         =   "Click the Form"
   ClientHeight    =   6045
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   8040
   LinkTopic       =   "Form1"
   ScaleHeight     =   6045
   ScaleWidth      =   8040
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "frmThreadCall"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'ensure a unique Key for each of your Threads...
Private Const ThreadKey$ = "Thread_HelloWorld"
'and specify the Class, for which an instance is created on the Thread
Private Const ThreadClass$ = "cThread"

'this is the clientside ThreadHandler - if you set this to nothing, then
'also the Thread (including the ThreadObject) it "controls" will be terminated
Private WithEvents TH As cThreadHandler
Attribute TH.VB_VarHelpID = -1

Private Sub Form_Load()
Dim ThreadLibPath As String 'specify, in which precompiled ThreadLib your ThreadClasses reside in
 ThreadLibPath = App.Path & "\ThreadLib.dll"

Dim RegFree As cRegFree
  Set RegFree = New cRegFree
  Set TH = RegFree.ThreadObjectCreate(ThreadKey, ThreadLibPath, ThreadClass)
End Sub

Private Sub Form_Click()
Dim StrResult As String
  Cls
  
  If Not TH.IsConnected Then
    MsgBox "Thread is not connected anymore": Exit Sub
  End If
  
  'first a synchronous call against our ThreadObject, which we created in Form_Load
  StrResult = TH.CallSynchronous("StringReflection", "ABC")
  Print "Direct (synchronous) Thread-Call with result: "; StrResult; vbCrLf
  
  'now an async-call, which makes use of the TH-Events to talk-back to us
  TH.CallAsync "StringReflection", "ABC"
  
  'and another one, which delivers a disconnected ADO-Rs back to us...
  'The Select itself is performed on the thread in a non-blocking way
  Dim CnnString As String, SQL As String
  CnnString = "Provider=Microsoft.Jet.OLEDB.4.0;" & _
              "Data Source=" & App.Path & "\Test.mdb"
  SQL = "Select * From T Where ID Between 10 And 20"
  TH.CallAsync "GetADORsFromSQL", CnnString, SQL
End Sub

'Our TH-Object here is the clientside Threadhandler, which is able to receive
'the results from async-Calls (when TH was declared WithEvents)
Private Sub TH_MethodFinished(MethodName As String, Result As Variant, ErrString As String, ErrSource As String, ByVal ErrNumber As Long)
  If Len(ErrString) Then
    Print "TH-"; MethodName, ErrString, ErrSource, ErrNumber
    Exit Sub
  End If
  
  Print "MethodFinished-Event of TH for: "; MethodName;
  
  Select Case LCase$(MethodName)
    Case LCase$("StringReflection")
      Print " with Result: "; Result; vbCrLf
      
    Case LCase$("GetADORsFromSQL")
      Dim Rs As ADODB.Recordset, Fld As ADODB.Field
        Set Rs = Result
        Print " with Result: RecordCount = "; Rs.RecordCount; vbCrLf
        'now a short Rs-Dump for the current Rs-Content
        For Each Fld In Rs.Fields
          Print Fld.Name,
        Next Fld
        Print vbCrLf; String(128, "-")
        Do Until Rs.EOF
          For Each Fld In Rs.Fields
            Print Fld.Value,
          Next Fld
          Print
          Rs.MoveNext
        Loop
  End Select
End Sub


